asin.c
#include "math.h"
#include "errno.h"

double arcsine();

double asin(x)
double x;
{
	return arcsine(x,0);
}

double acos(x)
double x;
{
	return arcsine(x,1);
}

#define P1 -0.27368494524164255994e+2
#define P2 +0.57208227877891731407e+2
#define P3 -0.39688862997504877339e+2
#define P4 +0.10152522233806463645e+2
#define P5 -0.69674573447350646411
#define Q0 -0.16421096714498560795e+3
#define Q1 +0.41714430248260412556e+3
#define Q2 -0.38186303361750149284e+3
#define Q3 +0.15095270841030604719e+3
#define Q4 -0.23823859153670238830e+2

#define P(g) ((((P5*g P4)*g P3)*g P2)*g P1)
#define Q(g) (((((g Q4)*g Q3)*g Q2)*g Q1)*g Q0)

double arcsine(x,flg)
double x;
{
	double y, g, r;
	register int i;
	extern int errno;
	static double a[2] = { 0.0, 0.78539816339744830962 };
	static double b[2] = { 1.57079632679489661923, 0.78539816339744830962 };

	y = fabs(x);
	i = flg;
	if (y < 2.3e-10)
		r = y;
	else {
		if (y > 0.5) {
			i = 1-i;
			if (y > 1.0) {
				errno = EDOM;
				return 0.0;
			}
			g = (0.5-y)+0.5;
			g = ldexp(g,-1);
			y = sqrt(g);
			y = -(y+y);
		} else
			g = y*y;
		r = y + y*
				((P(g)*g)
				/Q(g));
	}
	if (flg) {
		if (x < 0.0)
			r = (b[i] + r) + b[i];
		else
			r = (a[i] - r) + a[i];
	} else {
		r = (a[i] + r) + a[i];
		if (x < 0.0)
			r = -r;
	}
	return r;
}
atan.c
#include "math.h"
#include "errno.h"

#ifdef MPU8086
#define MAXEXP	1024
#define MINEXP	-1023
#else
#define MAXEXP	504
#define MINEXP	-512
#endif

#define PI		3.14159265358979323846
#define PIov2	1.57079632679489661923

double atan2(v,u)
double u,v;
{
	double f, frexp();
	int vexp, uexp;
	extern int flterr;
	extern int errno;

	if (u == 0.0) {
		if (v == 0.0) {
			errno = EDOM;
			return 0.0;
		} else if (v > 0.0 )
			return PIov2;
		return -PIov2;
	}

	frexp(v, &vexp);
	frexp(u, &uexp);
	if (vexp-uexp > MAXEXP-3)	/* overflow */
		f = PIov2;
	else {
		if (vexp-uexp < MINEXP+3)	/* underflow */
			f = 0.0;
		else
			f = atan(fabs(v/u));
		if (u < 0.0)
			f = PI - f;
	}
	if (v < 0.0)
		f = -f;
	return f;
}

#define P0 -0.13688768894191926929e+2
#define P1 -0.20505855195861651981e+2
#define P2 -0.84946240351320683534e+1
#define P3 -0.83758299368150059274e+0
#define Q0 +0.41066306682575781263e+2
#define Q1 +0.86157349597130242515e+2
#define Q2 +0.59578436142597344465e+2
#define Q3 +0.15024001160028576121e+2

#define P(g) (((P3*g P2)*g P1)*g P0)
#define Q(g) ((((g Q3)*g Q2)*g Q1)*g Q0)

double atan(x)
double x;
{
	double f, r, g;
	int n;
	static double Avals[4] = {
		0.0,
		0.52359877559829887308,
		1.57079632679489661923,
		1.04719755119659774615
	};
	
	n = 0;
	f = fabs(x);
	if (f > 1.0) {
		f = 1.0/f;
		n = 2;
	}
	if (f > 0.26794919243112270647) {
		f = (((0.73205080756887729353*f - 0.5) - 0.5) + f) /
				(1.73205080756887729353 + f);
		++n;
	}
	if (fabs(f) < 2.3e-10)
		r = f;
	else {
		g = f*f;
		r = f + f *
			((P(g)*g)
			/Q(g));
	}
	if (n > 1)
		r = -r;
	r += Avals[n];
	if (x < 0.0)
		r = -r;
	return r;
}
floor.c
#include "math.h"

double floor(d)
double d;
{
	if (d < 0.0)
		return -ceil(-d);
	modf(d, &d);
	return d;
}

double ceil(d)
double d;
{
	if (d < 0.0)
		return -floor(-d);
	if (modf(d, &d) > 0.0)
		++d;
	return d;
}
pow.c
#include "math.h"
#include "errno.h"

double pow(a,b)
double a,b;
{
	double loga;
	extern int errno;
	
	if (a<=0.0) {
		if (a<0.0 || a==0.0 && b<=0.0) {
			errno = EDOM;
			return -HUGE_VAL;
		}
		else return 0.0;
	}
	loga = log(a);
	loga *= b;
	if (loga > LOGHUGE) {
		errno = ERANGE;
		return HUGE_VAL;
	}
	if (loga < LOGTINY) {
		errno = ERANGE;
		return 0.0;
	}
	return exp(loga);
}
log.c
#include "math.h"
#include "errno.h"

double log10(x)
double x;
{
	return log(x)*0.43429448190325182765;
}

#define A0 -0.64124943423745581147e+2
#define A1 +0.16383943563021534222e+2
#define A2 -0.78956112887491257267e+0
#define A(w) ((A2*w A1)*w A0)

#define B0 -0.76949932108494879777e+3
#define B1 +0.31203222091924532844e+3
#define B2 -0.35667977739034646171e+2
#define B(w) (((w B2)*w B1)*w B0)

#define C0 0.70710678118654752440
#define C1 0.693359375
#define C2 -2.121944400546905827679e-4

double log(x)
double x;
{
	double Rz, f, z, w, znum, zden, xn;
	int n;
	extern int errno;
	
	if (x <= 0.0) {
		errno = EDOM;
		return -HUGE_VAL;
	}
	f = frexp(x, &n);
	if (f > C0) {
		znum = (znum = f-0.5) - 0.5; /* the assignment prevents const. eval */
		zden = f*0.5 + 0.5;
	} else {
		--n;
		znum = f - 0.5;
		zden = znum*0.5 + 0.5;
	}
	z = znum/zden;
	w = z*z;
/* the lines below are split up to allow expansion of A(w) and B(w) */
	Rz = z + z * (w *
			 A(w)
			/B(w));
	xn = n;
	return (xn*C2 + Rz) + xn*C1;
}
random.c
/*
 * Random number generator -
 * adapted from the FORTRAN version 
 * in "Software Manual for the Elementary Functions"
 * by W.J. Cody, Jr and William Waite.
 */
double ran()
{
	static long int iy = 100001;
	
	iy *= 125;
	iy -= (iy/2796203) * 2796203;
	return (double) iy/ 2796203.0;
}

double randl(x)
double x;
{
	double exp();

	return exp(x*ran());
}
sin.c
#include "math.h"
#include "errno.h"

double cos(x)
double x;
{
	double sincos();

	return sincos(x, fabs(x) + 1.57079632679489661923, 0);
}

double sin(x)
double x;
{
	double sincos();
	
	if (x < 0.0)
		return sincos(x,-x,1);
	else
		return sincos(x,x,0);
}

#define R1 -0.16666666666666665052e+00
#define R2 +0.83333333333331650314e-02
#define R3 -0.19841269841201840457e-03
#define R4 +0.27557319210152756119e-05
#define R5 -0.25052106798274584544e-07
#define R6 +0.16058936490371589114e-09
#define R7 -0.76429178068910467734e-12
#define R8 +0.27204790957888846175e-14

#define YMAX 6.7465e09

static double sincos(x,y,sgn)
double x,y;
{
	double f, xn, r, g;
	extern int errno;

	if (y >= YMAX) {
		errno = ERANGE;
		return 0.0;
	}
	if (modf(y * 0.31830988618379067154, &xn) >= 0.5)
		++xn;
	if ((int)xn & 1)
		sgn = !sgn;
	if (fabs(x) != y)
		xn -= 0.5;
	g = modf(fabs(x), &x);		/* break into fraction and integer parts */
	f = ((x - xn*3.1416015625) + g) + xn*8.9089102067615373566e-6;
	if (fabs(f) > 2.3283e-10) {
		g = f*f;
		r = (((((((R8*g R7)*g R6)*g R5)*g
				R4)*g R3)*g R2)*g R1)*g;
		f += f*r;
	}
	if (sgn)
		f = -f;
	return f;
}
sinh.c
#include "math.h"
#include "errno.h"

extern int errno;

#define P0 -0.35181283430177117881e+6
#define P1 -0.11563521196851768270e+5
#define P2 -0.16375798202630751372e+3
#define P3 -0.78966127417357099479e+0
#define Q0 -0.21108770058106271242e+7
#define Q1 +0.36162723109421836460e+5
#define Q2 -0.27773523119650701667e+3

#define PS(x) (((P3*x P2)*x P1)*x P0)
#define QS(x) (((x Q2)*x Q1)*x Q0)

double sinh(x)
double x;
{
	double y, w, z;
	int sign;
	
	y = x;
	sign = 0;
	if (x < 0.0) {
		y = -x;
		sign = 1;
	}
	if (y > 1.0) {
		w = y - 0.6931610107421875000;
		if (w > LOGHUGE) {
			errno = ERANGE;
			z = HUGE_VAL;
		} else {
			z = exp(w);
			if (w < 19.95)
				z -= 0.24999308500451499336 / z;
			z += 0.13830277879601902638e-4 * z;
		}
		if (sign)
			z = -z;
	} else if (y < 2.3e-10)
		z = x;
	else {
		z = x*x;
		z = x + x *
				(z*(PS(z)
				/QS(z)));
	}
	return z;
}

double cosh(x)
double x;
{
	double y, w, z;
	
	y = fabs(x);
	if (y > 1.0) {
		w = y - 0.6931610107421875000;
		if (w > LOGHUGE) {
			errno = ERANGE;
			return HUGE_VAL;
		}
		z = exp(w);
		if (w < 19.95)
			z += 0.24999308500451499336 / z;
		z += 0.13830277879601902638e-4 * z;
	} else {
		z = exp(y);
		z = z*0.5 + 0.5/z;
	}
	return z;
}
sqrt.c
#include "math.h"
#include "errno.h"

double sqrt(x)
double x;
{
	double f, y;
	int n;
	extern int errno;
	
	if (x == 0.0)
		return x;
	if (x < 0.0) {
		errno = EDOM;
		return 0.0;
	}
	f = frexp(x, &n);
	y = 0.41731 + 0.59016 * f;
	y = (y + f/y);
	y = ldexp(y,-2) + f/y;	/* fast calculation of y2 */
	y = ldexp(y + f/y, -1);
	y = ldexp(y + f/y, -1);
	
	if (n&1) {
		y *= 0.70710678118654752440;
		++n;
	}
	return ldexp(y,n/2);
}
tan.c
#include "math.h"
#include "errno.h"

extern int errno;

static double tansub();

double cotan(x)
double x;
{
	double y;
	
	y = fabs(x);
	if (y < 1.0/HUGE_VAL) {
		errno = ERANGE;
		if (x < 0.0)
			return -HUGE_VAL;
		else
			return HUGE_VAL;
	}
	return tansub(x,y,2);
}

double tan(x)
double x;
{
	return tansub(x, fabs(x), 0);
}

#define P1 -0.13338350006421960681e+0
#define P2 +0.34248878235890589960e-2
#define P3 -0.17861707342254426711e-4
#define Q0 +1.0
#define Q1 -0.46671683339755294240e+0
#define Q2 +0.25663832289440112864e-1
#define Q3 -0.31181531907010027307e-3
#define Q4 +0.49819433993786512270e-6

#define P(f,g) (((P3*g P2)*g P1)*g*f + f)
#define Q(g) ((((Q4*g Q3)*g Q2)*g Q1)*g Q0)

#define YMAX 6.74652e09

static double tansub(x, y, flag)
double x,y;
{
	double f, g, xn;
	double xnum, xden;
	
	if (y > YMAX) {
		errno = ERANGE;
		return 0.0;
	}
	if (modf(x*0.63661977236758134308, &xn) >= 0.5)
		xn += (x < 0.0) ? -1.0 : 1.0;
	f = (x - xn*1.57080078125) + xn*4.454455103380768678308e-6;
	if (fabs(f) < 2.33e-10) {
		xnum = f;
		xden = 1.0;
	} else {
		g = f*f;
		xnum = P(f,g);
		xden = Q(g);
	}
	flag |= ((int)xn & 1);
	switch (flag) {
	case 1:		/* A: tan, xn odd */
		xnum = -xnum;
	case 2:		/* B: cotan, xn even */
		return xden/xnum;
		
	case 3:		/* C: cotan, xn odd */
		xnum = -xnum;
	case 0:		/* D: tan, xn even */
		return xnum/xden;
	}
	return 0.0;
}
tanh.c
#include "math.h"

#define P0 -0.16134119023996228053e+4
#define P1 -0.99225929672236083313e+2
#define P2 -0.96437492777225469787e+0
#define Q0 +0.48402357071988688686e+4
#define Q1 +0.22337720718962312926e+4
#define Q2 +0.11274474380534949335e+3

#define gP(g) (((P2*g P1)*g P0)*g)
#define Q(g) (((g Q2)*g Q1)*g Q0)

double tanh(x)
double x;
{
	double f,g,r;
	
	f = fabs(x);
	if (f > 25.3)
		r = 1.0;
	else if (f > 0.54930614433405484570) {
		r = 0.5 - 1.0/(exp(f+f)+1.0);
		r += r;
	} else if (f < 2.3e-10)
		r = f;
	else {
		g = f*f;
		r = f + f*
			(gP(g)
			/Q(g));
	}
	if (x < 0.0)
		r = -r;
	return r;
}
exp.c
#include "math.h"
#include "errno.h"

#define P0 0.249999999999999993e+0
#define P1 0.694360001511792852e-2
#define P2 0.165203300268279130e-4
#define Q0 0.500000000000000000e+0
#define Q1 0.555538666969001188e-1
#define Q2 0.495862884905441294e-3

#define P(z) ((P2*z + P1)*z + P0)
#define Q(z) ((Q2*z + Q1)*z + Q0)

#define EPS	2.710505e-20

double
exp(x)
double x;
{
	int n;
	double xn, g, r, z;
	extern int errno;
	
	if (x > LOGHUGE) {
		errno = ERANGE;
		return HUGE_VAL;
	}
	if (x < LOGTINY) {
		errno = ERANGE;
		return 0.0;
	}
	if (fabs(x) < EPS)
		return 1.0;
	n = z = x * 1.4426950408889634074;
	if (n < 0)
		--n;
	if (z-n >= 0.5)
		++n;
	xn = n;
	g = ((x - xn*0.693359375)) + xn*2.1219444005469058277e-4;
	z = g*g;
	r = P(z)*g;
	r = 0.5 + r/(Q(z)-r);
	return ldexp(r,n+1);
}
fabs.c
double
fabs(f)
double f;
{
	return f>=0?f:-f;
}
flt65.a65
*:ts=8
* Copyright (c) 1982,1985 by Manx Software Systems
*
*
	instxt	<zpage.h>


PREC	EQU	8

	dseg
FADDR	fdb	FREG1
FREG1	rmb	14
*
	cseg
	public	.flt65
.flt65
*
	public	f.ld.1		;load freg1 into primary (float)
f.ld.1
*
	public	d.ld.1		;load freg1 into primary (double)
d.ld.1
*
	public	.dswap		;swap freg1 and primary
.dswap	lda	FADDR
	ldx	ACC
	sta	ACC
	stx	FADDR
	lda	FADDR+1
	ldx	ACC+1
	sta	ACC+1
	stx	FADDR+1
exit	ldy	#1
	lda	#0
	tax
	rts
*
	public	.dpsh0
.dpsh0	sec
	lda	SP
	sbc	#PREC+2
	sta	SP
	bcs	dpsh1
	dec	SP+1
dpsh1	ldy	#PREC+1
dpsh2	lda	(ACC),Y
	sta	(SP),Y
	dey
	bpl	dpsh2
	bmi	exit
*
	public	.dpsh1
.dpsh1	jsr	.dswap
	jsr	.dpsh0
	jmp	.dswap
*
	public	.dpul0
.dpul0	ldy	#PREC+1
dpul1	lda	(SP),Y
	sta	(ACC),Y
	dey
	bpl	dpul1
	clc
	lda	SP
	adc	#PREC+2
	sta	SP
	bcc	exit
	inc	SP+1
	bne	exit
*
	public	.dpul1
.dpul1	jsr	.dswap
	jsr	.dpul0
	jmp	.dswap
*
	public	f.ls.0		;load freg0 into secondary (float)
f.ls.0
*
	public	d.ls.0		;load freg0 into secondary (double)
d.ls.0
	jmp	.swapd#
*
	public	f.ls.1		;load freg1 into secondary (float)
f.ls.1
*
	public	d.ls.1		;load freg1 into secondary (double)
d.ls.1
	lda	FADDR
	ldx	SEC
	sta	SEC
	stx	FADDR
	lda	FADDR+1
	ldx	SEC+1
	sta	SEC+1
	stx	FADDR+1
	ldx	#0
	rts
*
	public	f.ld.i		;load immediate into primary (float)
f.ld.i
*
	public	d.ld.i		;load immediate into primary (double)
d.ld.i
	jsr	immed
	jmp	.ldacc#
*
	public	f.ls.i		;load immediate into secondary (float)
f.ls.i
*
	public	d.ls.i		;load immediate into secondary (double)
d.ls.i
	jsr	immed
	jmp	.ldsec#
*
immed	tsx
	clc
	lda	$103,X
	sta	VAL
	adc	#8
	sta	$103,X
	lda	$104,X
	sta	VAL+1
	adc	#0
	sta	$104,X
	inc	VAL
	bne	imm1
	inc	VAL+1
imm1	ldx	#0
	rts
*
	public	f.ld.g		;load global into primary (float)
f.ld.g	jsr	twoval
	jmp	.lsacc#
*
	public	d.ld.g		;load global into primary (double)
d.ld.g	jsr	twoval
	jmp	.ldacc#
*
	public	f.ls.g		;load global into secondary (float)
f.ls.g	jsr	twoval
	jmp	.lssec#
*
	public	d.ls.g		;load global into secondary (double)
d.ls.g	jsr	twoval
	jmp	.ldsec#
*
	public	f.ld.s		;load star into primary (float)
f.ld.s	jsr	star
	jmp	.lsacc#
*
	public	d.ld.s		;load star into primary (double)
d.ld.s	jsr	star
	jmp	.ldacc#
*
	public	f.ls.s		;load star into secondary (float)
f.ls.s	jsr	star
	jmp	.lssec#
*
	public	d.ls.s		;load star into secondary (double)
d.ls.s	jsr	star
	jmp	.ldsec#
*
	public	f.ld.l		;load local into primary (float)
f.ld.l	jsr	twolcl
	jmp	.lsacc#
*
	public	d.ld.l		;load local into primary (double)
d.ld.l	jsr	twolcl
	jmp	.ldacc#
*
	public	f.ls.l		;load local into secondary (float)
f.ls.l	jsr	twolcl
	jmp	.lssec#
*
	public	d.ls.l		;load local into secondary (double)
d.ls.l	jsr	twolcl
	jmp	.ldsec#
*
	public	f.ld.ls		;load local into primary (float)
f.ld.ls	jsr	onelcl
	jmp	.lsacc#
*
	public	d.ld.ls		;load local into primary (double)
d.ld.ls	jsr	onelcl
	jmp	.ldacc#
*
	public	f.ls.ls		;load local into secondary (float)
f.ls.ls	jsr	onelcl
	jmp	.lssec#
*
	public	d.ls.ls		;load local into secondary (double)
d.ls.ls	jsr	onelcl
	jmp	.ldsec#
*
	public	f.st.g		;store global from primary (float)
f.st.g	jsr	twoval
	jmp	.ssacc#
*
	public	d.st.g		;store global from primary (double)
d.st.g	jsr	twoval
	jmp	.sdacc#
*
	public	f.st.s		;store star from primary (float)
f.st.s	jsr	star
	jmp	.ssacc#
*
	public	d.st.s		;store star from primary (double)
d.st.s	jsr	star
	jmp	.sdacc#
*
	public	f.st.l		;store local from primary (float)
f.st.l	jsr	twolcl
	jmp	.ssacc#
*
	public	d.st.l		;store local from primary (double)
d.st.l	jsr	twolcl
	jmp	.sdacc#
*
	public	f.st.ls		;store local from primary (float)
f.st.ls	jsr	onelcl
	jmp	.ssacc#
*
	public	d.st.ls		;store local from primary (double)
d.st.ls	jsr	onelcl
	jmp	.sdacc#
*
twoval	tsx
	clc
	lda	$103,X
	sta	VAL
	adc	#2
	sta	$103,X
	lda	$104,X
	sta	VAL+1
	adc	#0
	sta	$104,X
	ldy	#1
	lda	(VAL),Y
	tax
	iny
	lda	(VAL),Y
	sta	VAL+1
	stx	VAL
	ldx	#0
	rts
*
oneval	tsx
	clc
	lda	$105,X
	sta	VAL
	adc	#1
	sta	$105,X
	lda	$106,X
	sta	VAL+1
	adc	#0
	sta	$106,X
	ldy	#1
	ldx	#0
	lda	(VAL),Y
	rts
*
onelcl	jsr	oneval
	bpl	onel1
	dey
onel1	dey
	clc
	adc	FRAME
	sta	VAL
	tya
	adc	FRAME+1
	sta	VAL+1
	rts
*
twolcl	pla
	sta	$40
	pla
	sta	$41
	jsr	twoval
	lda	$41
	pha
	lda	$40
	pha
	clc
	lda	VAL
	adc	FRAME
	sta	VAL
	lda	VAL+1
	adc	FRAME+1
	sta	VAL+1
	rts
*
star	jsr	oneval
	tax
	lda	0,X
	sta	VAL
	lda	1,X
	sta	VAL+1
	ldx	#0
	rts
*
	public	f.psh.i		;push immediate (float)
f.psh.i	ldy	#4
	jsr	immed
	jmp	fpush
*
	public	f.psh.g		;push global (float)
f.psh.g	jsr	twoval
	jmp	fpush
*
	public	f.psh.s		;push star (float)
f.psh.s	jsr	star
	jmp	fpush
*
	public	f.psh.l		;push local (float)
f.psh.l	jsr	twolcl
	jmp	fpush
*
	public	f.psh.ls	;push local (float)
f.psh.ls	jsr	onelcl
	jmp	fpush
*
	public	d.psh.i		;push immediate (double)
d.psh.i	ldy	#4
	jsr	immed
	jmp	dpush
*
	public	d.psh.g		;push global (double)
d.psh.g	jsr	twoval
	jmp	dpush
*
	public	d.psh.s		;push star (double)
d.psh.s	jsr	star
	jmp	dpush
*
	public	d.psh.l		;push local (double)
d.psh.l	jsr	twolcl
	jmp	dpush
*
	public	d.psh.ls	;push local (double)
d.psh.ls	jsr	onelcl
	jmp	dpush
*
	public	f.psh.0		;push freg0
f.psh.0	
*
	public	d.psh.0		;push freg0
d.psh.0	
*
	pla
	sta	$40
	pla
	sta	$41
	ldy	#9
	jsr	.rndit#
	ldy	#8
stflt1	lda	(ACC),Y
	pha
	dey
	cpy	#1
	bne	stflt1
	clc
	lda	(ACC),Y
	adc	#64
	sta	VAL
	dey
	lda	(ACC),Y
	and	#$80
	ora	VAL
	pha
	lda	$41
	pha
	lda	$40
	pha
	rts
*
	dseg
tmp	rmb	2
*
	cseg
	public	f.psh.1		;push freg1
f.psh.1	
*
	public	d.psh.1		;push freg1
d.psh.1	
*
	jsr	.dswap#
	pla
	sta	tmp
	pla
	sta	tmp+1
	jsr	f.psh.0
	lda	tmp+1
	pha
	lda	tmp
	pha
	jmp	.dswap#
*
fpush	ldy	#4
	pla
	sta	$40
	pla
	sta	$41
fpush1	lda	#0
	pha
	dey
	bne	fpush1
	ldy	#3
	bne	dpush1
*
dpush	ldy	#7
	pla
	sta	$40
	pla
	sta	$41
dpush1	lda	(VAL),Y
	pha
	dey
	bpl	dpush1
	lda	$41
	pha
	lda	$40
	pha
	rts
*
math.a65
*:ts=8
* Copyright (c) 1982,1985 by Manx Software Systems
*
	instxt	<zpage.h>

PREC	EQU	8

*
	public	frexp_
frexp_				;return mantissa and exponent
	jsr	calcexp		;calculate power of two exponent
	bne	retexp
	lda	#0
	sta	R0
	sta	R0+1
retexp	ldy	#10		;get addr of where to put exponent *jd 3/8/86
	lda	(SP),Y
	sta	VAL
	iny
	lda	(SP),Y
	sta	VAL+1
	ldy	#0
	lda	R0		;and store the base 2 exponent
	sta	(VAL),Y
	iny
	lda	R0+1
	sta	(VAL),Y
return	rts
*
	public	ldexp_
ldexp_			;load new exponent value (actually add to exponent)
	jsr	calcexp		;calculate power of two exponent
	beq	return		;do nothing if number is zero or unnormalized
	ldy	#10		; *jd 3/8/86
	clc			;add argument to exponent
	lda	(SP),Y
	adc	R0
	sta	R0
	iny
	lda	(SP),Y
	adc	R0+1
	sta	R0+1
	bpl	posexp
	sec			;make positive for div and modulo below
	lda	#0
	sbc	R0
	sta	R0
	lda	#0
	sbc	R0+1
	sta	R0+1
	lda	R0
	and	#7		;save amount to shift
	pha
	jsr	rsexp		;make power of 256
	sec			;change the sign back
	lda	#0
	sbc	R0
	sta	R0
	jmp	ldrs
posexp
	ora	R0		;check if zero
	beq	return		;no adjustment needed
	lda	R0
	pha			;save to compute left shift
	jsr	rsexp		;make power of 256
	pla
	and	#7
	beq	ldrsx
	inc	R0		;bump exponent to make right shift
	clc
	eor	#$ff
	adc	#9		;compensate for +1 (c = -(x - 8))
ldrsx	pha
ldrs	ldy	#1		;point at exponent
	lda	R0
	sta	(ACC),Y		;save exponent
	pla			;recover count
	sta	VAL
rsloop	dec	VAL
	bmi	return
	ldy	#2
	ldx	#7
	clc
rslp	lda	(ACC),Y
	ror	A
	sta	(ACC),Y
	iny
	dex
	bne	rslp
	beq	rsloop
*
rsexp	ldy	#3
rselp	lsr	R0+1
	ror	R0
	dey
	bne	rselp
	rts
*
calcexp
	clc			;*jd 3/8/86
	lda	SP
	adc	#2		;*jd 3/8/86
	sta	VAL
	lda	SP+1
	adc	#0		;*jd 3/8/86
	sta	VAL+1
	jsr	.ldacc#		;load double into floating point accumulator
	ldy	#1
	lda	(ACC),Y		;get exponent value
	cmp	#-64
	bne	*+3
creturn	rts
	sta	R0		;save value
	lda	#0		;make exponent zero for return
	sta	(ACC),Y
	ldy	#0		;sign extend value
	lda	R0
	bpl	*+3
	dey
	sty	R0+1
	ldy	#3		;multiply by eight
calclp	asl	R0		; to make power of two
	rol	R0+1
	dey
	bne	calclp
	ldy	#2		;get first byte of mantissa
	lda	(ACC),Y
	beq	creturn		;unnormalized number, give up
lshft	lda	(ACC),Y
	and	#$80		;test high bit of mantissa
	bne	creturn		;mantissa >= 0.5
	lda	R0		;else decrement the exponent and
	bne	*+4
	dec	R0+1
	dec	R0
	clc
	ldy	#8		; ... shift the mantissa left one bit
	ldx	#7
lsloop	lda	(ACC),Y
	rol	A
	sta	(ACC),Y
	dey
	dex
	bne	lsloop
	iny
	bne	lshft
*
	public	modf_
modf_				;split into integral and fraction parts
	clc			; **jd 3/8/86
	lda	SP		;load double into floating point accumulator
	adc	#2		; *jd 3/8/86
	sta	VAL
	lda	SP+1
	adc	#0		; *jd 3/8/86
	sta	VAL+1
	jsr	.ldacc#
	ldy	#10		;get addr of place to store integral part * jd 3/8/86
	lda	(SP),Y
	sta	VAL
	iny
	lda	(SP),Y
	sta	VAL+1
	lda	#0
	ldy	#7		;zero out the integer
mdclr	sta	(VAL),Y
	dey
	bpl	mdclr
	clc
	ldy	#1		;point at exponent part
	lda	(ACC),Y
	bmi	mreturn
	bne	*+3
mreturn	rts
	adc	#64
	and	#$7f
	sta	R0
	dey
	lda	(ACC),Y		;get sign of number
	and	#$80		;isolate
	ora	R0		;combine with exponent
	ldy	#0
	sta	(VAL),Y		;store at iptr
	iny
	sty	R0+2		; R0+2 is index into result
	lda	(ACC),Y		;refetch exponent
	cmp	#7		limit move loop to 7 bytes
	bcc	expok
	lda	#7
expok	sta	R0		;save count for loop
	sec
	lda	#7		;7 - loop count
	sbc	R0
	sta	R0+1		;save # bytes in fraction in R0+1
	lda	#2		;point at beginning of mantissa
	sta	R0+3		; R0+3 is index into acc
intmov				;copy integer part into given area
	ldy	R0+3
	lda	(ACC),Y
	ldy	R0+2
	sta	(VAL),Y
	inc	R0+2
	inc	R0+3
	dec	R0
	bne	intmov
*
fnorm				;note: R0 is zero at start of loop
	dec	R0+1
	bmi	zfrac		;number of bytes in fraction now zero
	ldy	R0+3
	lda	(ACC),Y
	bne	found		;look for non-zero byte
	dec	R0+1
	inc	R0+3
	bne	fnorm
found	ldy	#1
	lda	R0		;store exponent
	sta	(ACC),Y
	iny
	sty	R0+2		;this is now index into acc as well
	ldx	#7		;count of number that must be cleared
frcmov	ldy	R0+3		;get fraction byte
	lda	(ACC),Y
	ldy	R0+2		;and move to front
	sta	(ACC),Y
	inc	R0+2
	inc	R0+3
	dex			;decrement total byte count
	dec	R0+1		;decrement number of bytes in fraction
	bpl	frcmov		;still more to do
	lda	#0		;fill rest with zero
frcclr	sta	(ACC),Y
	iny
	dex
	bne	frcclr
	rts
zfrac	ldy	#PREC+1		;no fraction, make zero
	lda	#0
zfrac1	sta	(ACC),Y
	dey
	bpl	zfrac1
	ldy	#1
	lda	#-64
	sta	(ACC),Y
	rts
*
*
	ext	.fltused
*
ftoa.a65
*:ts=8
* Copyright (c) 1982 by Manx Software Systems
*
	instxt	<zpage.h>

STR	EQU	R0
DEXP	EQU	R0+2
NDIG	EQU	R1
B	EQU	R1+2
INDEX	EQU	R2
MAXDIG	EQU	R2+1
FMT	EQU	R2+2

PREC	EQU	8

*
*	float to ascii conversion
*	ftoa(double, str, maxwidth, fmt);
*		fmt == 0 => 'e'
*		       1 => 'f'
*		       2 => 'g'
*
	public	ftoa_
ftoa_	ldy	#0		;get the value into the double acc
	clc
	lda	SP
	adc	#2
	sta	VAL
	tya
	adc	SP+1
	sta	VAL+1
	jsr	.ldacc#
	ldy	#10		;next get a ptr to the char string
	lda	(SP),Y
	sta	STR
	iny
	lda	(SP),Y
	sta	STR+1
	iny			;get the number of digits to display
	clc
	lda	(SP),Y
	adc	#1
	cmp	#17		;no more than 16
	bcc	ftoa1
	lda	#16
ftoa1	sta	MAXDIG
	sta	NDIG
	lda	#0
	sta	NDIG+1
	iny
	iny			;get a flag for E or F format
	lda	(SP),Y
	sta	FMT
*
	ldy	#0
	sty	DEXP		;initialize decimal exponent count
	sty	DEXP+1
	lda	(ACC),Y
	bpl	ftoa2		;check for negative number
	eor	#$80
	sta	(ACC),Y
	lda	#'-
	sta	(STR),Y
	iny
ftoa2	sty	INDEX
	jsr	dtst
	beq	ftoa6
ftoa3	ldy	#1		;get the exponent
	lda	(ACC),Y
	cmp	#1
	bmi	ftoa5		;acc too small
	bne	ftoa4		;acc too big
	iny			;acc could be just right
	lda	(ACC),Y
	cmp	#10		;must be less than ten
	bcc	ftoa6
ftoa4	jsr	msmall		;make it smaller
	jmp	ftoa3
ftoa5	jsr	mbig		;make it bigger
	jmp	ftoa3
ftoa6	lda	FMT		;F or E format
	cmp	#2
	bne	ffmt
*
	public	gfmt
gfmt	ldy	#12
	lda	(SP),Y
	cmp	#17
	bcc	gfmt1
	lda	#16
gfmt1	sta	NDIG
	lda	#0
	sta	NDIG+1
	lda	DEXP
	cmp	#-4
	lda	DEXP+1
	sbc	#-1
	bvs	j1
	bmi	gfmt2
	bpl	j2
j1	bpl	gfmt2
j2	lda	DEXP
	cmp	NDIG
	lda	DEXP+1
	sbc	NDIG+1
	bvs	j3
	bmi	ftoa7
	bpl	gfmt2
j3	bpl	ftoa7
gfmt2	lda	#0
	sta	FMT
*
ffmt	lda	FMT
	beq	ftoa7
	clc
	lda	NDIG		;for F format
	adc	DEXP
	sta	NDIG
	lda	NDIG+1
	adc	DEXP+1
	sta	NDIG+1
	jmp	ftoa7
*
ftoa7	ldx	NDIG+1		;what's the precision
	bmi	ftoa7a
	bne	ftoa8a
	ldx	NDIG
	dex
	bpl	ftoa8
ftoa7a	ldx	#0
ftoa8	cpx	#16
	bcc	ftoa9
ftoa8a	ldx	#16
ftoa9	jsr	dornd		;add in appropriate .5
ftoa10	lda	DEXP
	pha
	lda	DEXP+1
	pha
	ldx	#0
	lda	FMT
	beq	ftoa15		;E fmt, skip
	ldx	DEXP
	lda	DEXP+1
	bpl	ftoa15		;F fmt, no leading zeros
	ldy	INDEX
	lda	#'0		;put out leading zeros
	sta	(STR),Y
	iny
	lda	#'.		;put out the decimal also
	sta	(STR),Y
	iny
	lda	NDIG+1		;how's the precision
	bmi	ftoa11
	lda	DEXP
	eor	#$FF		;negate and decrement
	jmp	ftoa12
ftoa11	lda	MAXDIG
ftoa12	tax
	beq	ftoa14
	lda	#'0
ftoa13	sta	(STR),Y		;fill with zeroes
	iny
	dex
	bne	ftoa13
ftoa14	sty	INDEX		;save index
	lda	#-1
	tax
ftoa15	sta	DEXP+1		;location of decimal point
	stx	DEXP
	lda	#-1
	sta	B
	sta	B+1
ftoa16	inc	B		;next character
	bne	ftoa16a
	inc	B+1
ftoa16a	lda	B
	cmp	NDIG		;done enough chars yet
	lda	B+1
	sbc	NDIG+1
	bcs	ftoa19
	ldy	#1
	lda	(ACC),Y
	tax
	lda	#'0
	cpx	#1
	bne	ftoa17
	iny
	clc
	adc	(ACC),Y
	tax
	lda	#0
	sta	(ACC),Y
	txa
ftoa17	ldy	INDEX
	sta	(STR),Y
	iny
	lda	B
	cmp	DEXP
	bne	ftoa18
	lda	B+1
	cmp	DEXP+1
	bne	ftoa18
	lda	#'.
	sta	(STR),Y
	iny
ftoa18	sty	INDEX
	jsr	fmul
	jmp	ftoa16
ftoa19	pla
	sta	DEXP+1
	pla
	sta	DEXP
	lda	FMT
	bne	ftoa24
	ldy	INDEX
	lda	#'E
	sta	(STR),Y
	iny
	lda	#'+
	sta	(STR),Y
	lda	DEXP+1
	bpl	ftoa20
	lda	#'-
	sta	(STR),Y
	sec
	lda	#0
	sbc	DEXP
	sta	DEXP
	lda	#0
	sta	DEXP+1
ftoa20	iny
	lda	DEXP
	cmp	#100
	bcc	ftoa21
	tax
	lda	#'1
	sta	(STR),Y
	iny
	sec
	txa
	sbc	#100
ftoa21	ldx	#0
ftoa22	cmp	#10
	bcc	ftoa23
	sbc	#10
	inx
	bne	ftoa22
ftoa23	iny
	adc	#'0
	sta	(STR),Y
	dey
	txa
	adc	#'0
	sta	(STR),Y
	iny
	iny
	sty	INDEX
ftoa24	ldy	INDEX
	lda	#0
	sta	(STR),Y
	rts
*
*	make the accum smaller
*
msmall	ldx	#0
msm1	ldy	#1
msm2	lda	(ACC),Y
	cmp	tens,X
	bcc	msm4
	bne	msm5
	inx
	iny
	cpy	#9
	bne	msm2
	dex
	bne	msm5
msm4	txa
	adc	#8
	and	#$F8
	tax
	cpx	#56
	bne	msm1
	rts
msm5	txa
	and	#$F8
	clc
	adc	#56
	tax
	jsr	copy
	jmp	msmall
*
*	make the accum bigger
*
mbig	ldx	#64
mbig1	ldy	#1
	lda	(ACC),Y
	cmp	tens,X
	bmi	mbig5
	bne	mbig4
	inx
	iny
mbig2	lda	(ACC),Y
	cmp	tens,X
	bcc	mbig5
	bne	mbig4
	inx
	iny
	cpy	#9
	bne	mbig2
	dex
	bne	mbig5
mbig4	txa
	adc	#8
	and	#$F8
	tax
	cpx	#120
	bne	mbig1
	rts
mbig5	txa
	and	#$F8
	sec
	sbc	#64
	tax
	jsr	copy
	jmp	mbig
*
*
*
copy	txa
	lsr	A
	lsr	A
	tay
	clc
	lda	tentab,Y
	adc	DEXP
	sta	DEXP
	iny
	lda	tentab,Y
	adc	DEXP+1
	sta	DEXP+1
domul	txa
	clc
	adc	#7
	tax
	ldy	#PREC+1
	lda	#$0
copy1	sta	(SEC),Y
	dey
	cpy	#8
	bne	copy1
copy2	lda	tens,X
	sta	(SEC),Y
	dex
	dey
	bne	copy2
	lda	#0
	sta	(SEC),Y
	jmp	.muld#
*
*	round to the amount in X
*
dornd	txa
	asl	A
	asl	A
	asl	A
	tax
	ldy	#0
	tya
	sta	(SEC),Y
	iny
	sec
	lda	half,X
	sbc	#64
	sta	(SEC),Y
	iny
	inx
dornd1	lda	half,X
	sta	(SEC),Y
	iny
	inx
	cpy	#9
	bne	dornd1
	lda	#0
dornd2	sta	(SEC),Y
	iny
	cpy	#14
	bne	dornd2
	jsr	.addd#
	ldy	#1
	lda	(ACC),Y
	cmp	#1
	bne	dornd3
	iny
	lda	(ACC),Y
	cmp	#10		;still smaller than 10?
	bcc	dornd3
	jsr	msmall		;no, div again
	lda	FMT
	beq	dornd3
	inc	NDIG
	bne	dornd3
	inc	NDIG+1
dornd3	rts
*
*
dtst	ldy	#0
	lda	(ACC),Y
	bne	dtst1
	iny
	lda	(ACC),Y
	cmp	#-64
	bne	dtst1
	iny
	lda	(ACC),Y
	bne	dtst1
	lda	#0
	rts
dtst1	lda	#1
	rts
*
*	fast multiply by 10
*
fmul	lda	#0
	ldy	#PREC+1
fmul1	sta	(SEC),Y
	dey
	bpl	fmul1
	ldy	#1
	tya
	sta	(SEC),Y
	iny
	lda	#10
	sta	(SEC),Y
	jsr	.swapd#
	jmp	.muld#
*
*	necessary data
*
	dseg
half
* 0.5,
	fcb	$40,$80,$00,$00,$00,$00,$00,$00
* 0.05,
	fcb	$40,$0C,$CC,$CC,$CC,$CC,$CC,$CD
* 0.005,
	fcb	$40,$01,$47,$AE,$14,$7A,$E1,$48
* 0.0005,
	fcb	$3F,$20,$C4,$9B,$A5,$E3,$54,$00
* 0.00005,
	fcb	$3F,$03,$46,$DC,$5D,$63,$88,$66
* 0.000005,
	fcb	$3E,$53,$E2,$D6,$23,$8D,$A3,$CD
* 0.0000005,
	fcb	$3E,$08,$63,$7B,$D0,$5A,$F6,$C8
* 0.00000005,
	fcb	$3D,$D6,$BF,$94,$D5,$E5,$7A,$66
* 0.000000005,
	fcb	$3D,$15,$79,$8E,$E2,$30,$8C,$3D
* 0.0000000005,
	fcb	$3D,$02,$25,$C1,$7D,$04,$DA,$D3
* 0.00000000005,
	fcb	$3C,$36,$F9,$BF,$B3,$AF,$7B,$80
* 0.000000000005,
	fcb	$3C,$05,$7F,$5F,$F8,$5E,$59,$26
* 0.0000000000005,
	fcb	$3B,$8C,$BC,$CC,$09,$6F,$50,$9A
* 0.00000000000005,
	fcb	$3B,$0E,$12,$E1,$34,$24,$BB,$43
* 0.000000000000005,
	fcb	$3B,$01,$68,$49,$B8,$6A,$12,$BA
* 0.0000000000000005,
	fcb	$3A,$24,$07,$5F,$3D,$CE,$AC,$33
* 0.00000000000000005,
	fcb	$3A,$03,$9A,$56,$52,$FB,$11,$38
*
tens
* 1e64
	fcb	$1B,$18,$4F,$03,$E9,$3F,$F9,$F5
* 1e32
	fcb	$0E,$04,$EE,$2D,$6D,$41,$5B,$87
* 1e16
	fcb	$07,$23,$86,$F2,$6F,$C1,$00,$00
* 1e8
	fcb	$04,$05,$F5,$E1,$00,$00,$00,$00
* 1e4
	fcb	$02,$27,$10,$00,$00,$00,$00,$00
* 1e2
	fcb	$01,$64,$00,$00,$00,$00,$00,$00
* 1e1
	fcb	$01,$0A,$00,$00,$00,$00,$00,$00
* 1e-64
	fcb	$E6,$0A,$87,$FE,$A2,$7A,$53,$A9
* 1e-32
	fcb	$F3,$33,$EC,$47,$AB,$51,$4E,$7F
* 1e-16
	fcb	$FA,$07,$34,$AC,$A5,$F6,$22,$72
* 1e-8
	fcb	$FD,$2A,$F3,$1D,$C4,$61,$18,$79
* 1e-4
	fcb	$FF,$06,$8D,$B8,$BA,$C7,$10,$CD
* 1e-2
	fcb	$00,$02,$8F,$5C,$28,$F5,$C2,$8F
* 1e-1
	fcb	$00,$19,$99,$99,$99,$99,$99,$9A
* 1e0
	fcb	$01,$01,$00,$00,$00,$00,$00,$00
*
tentab
	fdb	-64,-32,-16,-8,-4,-2,-1,64,32,16,8,4,2,1
	cseg
atof.a65
*:ts=8
* Copyright (c) 1982,1985 by Manx Software Systems
*
	instxt	<zpage.h>

INDEX	EQU	R0
FLAGS	EQU	R0+1
DEXP	EQU	R0+2
TMP0	EQU	R1
STR	EQU	R1+1
*
PREC	EQU	8
*
*
*	atof -	called with addr of string on stack
*		returns with double value in ACC
*
	cseg
	public	atof_
atof_	ldy	#0		;initialize variables to zero
	sty	INDEX
	sty	FLAGS
	sty	DEXP
	sty	DEXP+1
	sty	TMP0
	tya
	ldy	#PREC+1		;initialize acc to zero
atof1	sta	(ACC),Y
	dey
	bpl	atof1
	ldy	#1
	lda	#-64
	sta	(ACC),Y
	iny
	lda	(SP),Y		;pointer to string in STR
	sta	STR
	iny
	lda	(SP),Y
	sta	STR+1
	ldy	#0
	lda	(STR),Y		;check sign of number
	cmp	#'+
	beq	getnum
	cmp	#'-
	bne	getnum1
	lda	#1		;set minus flag
	sta	FLAGS
*
*	convert the main part of the number
*
getnum	inc	INDEX		;bump to next char
	ldy	INDEX
	lda	(STR),Y
getnum1	cmp	#'.		;is it a decimal point
	bne	getnum3
	bit	FLAGS		;check the dp flag
	bvc	getnum2
	jmp	convert		;already have decimal pt
getnum2	lda	FLAGS		;set the dp flag
	ora	#$40
	sta	FLAGS
	bne	getnum
getnum3	cmp	#'0		;is it a number
	bcc	chkexp		;no, check if exponent
	cmp	#'9+1
	bcs	chkexp
	sec
	sbc	#'0
	sta	TMP0		;save for the moment
	jsr	mul10		;multiply ACC by 10.0
	ldy	#0
	tya
getnum4	sta	(SEC),Y		;clear the SEC
	iny
	cpy	#PREC+2
	bne	getnum4
	lda	#1
	tay
	sta	(SEC),Y
	iny
	lda	TMP0
	beq	getnum5
	sta	(SEC),Y
	jsr	.addd#
getnum5	bit	FLAGS		;are we doing fraction?
	bvc	getnum6
	sec
	lda	DEXP
	sbc	#1
	sta	DEXP
	lda	DEXP+1
	sbc	#0
	sta	DEXP+1
getnum6	jmp	getnum
*
*	get the exponent value
*
chkexp	cmp	#'e		;is it an exponent
	beq	doexp
	cmp	#'E
	beq	doexp
	jmp	convert
doexp	lda	#0
	sta	TMP0
	inc	INDEX
	ldy	INDEX
	lda	(STR),Y
	cmp	#'+
	beq	doexp1
	cmp	#'-
	bne	doexp2
	lda	FLAGS		;set exponent sign flag
	ora	#$80
	sta	FLAGS
doexp1	inc	INDEX
	ldy	INDEX
	lda	(STR),Y		;check if still a number
doexp2	sec
	sbc	#'0
	bcc	doexp3
	cmp	#10
	bcs	doexp3
	pha
	asl	TMP0
	lda	TMP0
	asl	A
	asl	A
	adc	TMP0
	sta	TMP0
	pla
	adc	TMP0
	sta	TMP0
	bcc	doexp1
doexp3	bit	FLAGS
	bpl	doexp4
	sec
	lda	DEXP
	sbc	TMP0
	sta	DEXP
	bcs	convert
	dec	DEXP+1
	jmp	convert
doexp4	clc
	lda	DEXP
	adc	TMP0
	sta	DEXP
	bcc	convert
	inc	DEXP+1
*
*	convert the decimal exponent
*
convert	lda	DEXP+1
	bmi	conv2
	bne	conv1
	lda	DEXP
	beq	conv3
conv1	jsr	mbig
	jmp	conv3
conv2	jsr	msmall
conv3	lda	FLAGS
	and	#1
	beq	conv4
	ldy	#0
	lda	(ACC),Y
	eor	#$80
	sta	(ACC),Y
conv4	rts
*
*	make the acc bigger
*
mbig	ldx	#7
	lda	DEXP+1
	bne	mbig2
	lda	DEXP
	bne	mbig1
	rts
mbig1	cmp	tentab,X
	bcs	mbig2
	inx
	bne	mbig1
mbig2	sec
	lda	DEXP
	sbc	tentab,X
	sta	DEXP
	lda	DEXP+1
	sbc	#0
	sta	DEXP+1
	jsr	copy
	jmp	mbig
*
*	make the acc smaller
*
msmall	ldx	#0
	lda	DEXP
	bne	msm1
	lda	DEXP+1
	bne	msm2
	rts
msm1	cmp	tentab,X
	bcc	msm2
	beq	msm2
	inx
	bne	msm1
msm2	sec
	lda	DEXP
	sbc	tentab,X
	sta	DEXP
	lda	DEXP+1
	sbc	#-1
	sta	DEXP+1
	jsr	copy
	jmp	msmall
*
*
*
mul10	ldx	#13
*
copy	txa
	asl	A
	asl	A
	asl	A
	adc	#7
	tax
	ldy	#PREC+1
	lda	#0
copy1	sta	(SEC),Y
	dey
	cpy	#8
	bne	copy1
copy2	lda	tens,X
	sta	(SEC),Y
	dex
	dey
	bne	copy2
	lda	#0
	sta	(SEC),Y
	jmp	.muld#
*
*
	dseg
*
tens
* 1e-64
	fcb	$E6,$0A,$87,$FE,$A2,$7A,$53,$A9
* 1e-32
	fcb	$F3,$33,$EC,$47,$AB,$51,$4E,$7F
* 1e-16
	fcb	$FA,$07,$34,$AC,$A5,$F6,$22,$72
* 1e-8
	fcb	$FD,$2A,$F3,$1D,$C4,$61,$18,$79
* 1e-4
	fcb	$FF,$06,$8D,$B8,$BA,$C7,$10,$CD
* 1e-2
	fcb	$00,$02,$8F,$5C,$28,$F5,$C2,$8F
* 1e-1
	fcb	$00,$19,$99,$99,$99,$99,$99,$9A
* 1e64
	fcb	$1B,$18,$4F,$03,$E9,$3F,$F9,$F5
* 1e32
	fcb	$0E,$04,$EE,$2D,$6D,$41,$5B,$87
* 1e16
	fcb	$07,$23,$86,$F2,$6F,$C1,$00,$00
* 1e8
	fcb	$04,$05,$F5,$E1,$00,$00,$00,$00
* 1e4
	fcb	$02,$27,$10,$00,$00,$00,$00,$00
* 1e2
	fcb	$01,$64,$00,$00,$00,$00,$00,$00
* 1e1
	fcb	$01,$0A,$00,$00,$00,$00,$00,$00
*
tentab
	fcb	-64,-32,-16,-8,-4,-2,-1,64,32,16,8,4,2,1
	cseg
flt2.a65
*:ts=8
* Copyright (c) 1982,1983,1985 by Manx Software Systems
*
*
	instxt	<zpage.h>

PREC	EQU	8

	public	.fltused
.fltused
	public	.flt2
.flt2
*
	public	.fltjmp
.fltjmp	lda	(PC),Y
	inc	PC
	bne	fltjmp1
	inc	PC+1
fltjmp1	asl	A
	tax
	lda	FTAB-2,X
	sta	VAL
	lda	FTAB-1,X
	sta	VAL+1
	jmp	(VAL)
*
FTAB	fdb	.muld#
	fdb	.divd#
	fdb	.addd#
	fdb	.subd#
	fdb	.negd
	fdb	.eqd#
	fdb	.ned#
	fdb	.ltd#
	fdb	.led#
	fdb	.gtd#
	fdb	.ged#
	fdb	.ldlpd
	fdb	.ldlsd
	fdb	.stld
	fdb	.pshld
	fdb	.ldgpd
	fdb	.ldgsd
	fdb	.stgd
	fdb	.pshgd
	fdb	.pshd
	fdb	.puld
	fdb	.ldsd
	fdb	.stsd
	fdb	.ldipd
	fdb	.ldisd
	fdb	.swapd#
	fdb	.inrd
	fdb	.dcrd
	fdb	.tstd#
	fdb	.ldlpf
	fdb	.ldlsf
	fdb	.stlf
	fdb	.pshlf
	fdb	.ldgpf
	fdb	.ldgsf
	fdb	.stgf
	fdb	.pshgf
	fdb	.ldsf
	fdb	.stsf
	fdb	.itod#
	fdb	.utod#
	fdb	.dtoi#
	fdb	.dtou#
	fdb	.xtod#
	fdb	.dtox#
*
*	store sec into location in VAL
*
.sssec	ldy	#5
	bne	sdsec1
.sdsec	ldy	#9
sdsec1	jsr	.swapd#
	jsr	.stflt#
	jmp	.swapd#
*
*	negate the accumulator
*
.negd	lda	(ACC),Y
	eor	#$80
	sta	(ACC),Y
	rts
*
*	push acc onto the stack
*
.pshd	sec
	lda	SP
	sbc	#8
	sta	SP
	sta	VAL
	bcs	pshd1
	dec	SP+1
pshd1	lda	SP+1
	sta	VAL+1
	jmp	.sdacc#
*
*	pop the stack into sec
*
.puld	lda	SP
	sta	VAL
	lda	SP+1
	sta	VAL+1
	jsr	.ldsec#
	clc
	lda	SP
	adc	#8
	sta	SP
	bcc	puld1
	inc	SP+1
puld1	rts
*
*
*
.ldlpf	jsr	twolcl
	jmp	.lsacc#
*
.ldlsf	jsr	twolcl
	jmp	.lssec#
*
.stlf	jsr	twolcl
	jmp	.ssacc#
*
.pshlf	jsr	twolcl
	jsr	.lsacc#
	jmp	.pshd#
*
.ldgpf	jsr	twoval
	jmp	.lsacc#
*
.ldgsf	jsr	twoval
	jmp	.lssec#
*
.stgf	jsr	twoval
	jmp	.ssacc#
*
.pshgf	jsr	twoval
	jsr	.lsacc#
	jmp	.pshd#
*
.ldsf	lda	R0
	sta	VAL
	lda	R0+1
	sta	VAL+1
	jmp	.lsacc#
*
.stsf	jsr	pul0#
	lda	R1
	sta	VAL
	lda	R1+1
	sta	VAL+1
	jmp	.ssacc#
*
.ldipd	lda	PC
	sta	VAL
	lda	PC+1
	sta	VAL+1
	jsr	.ldacc#
ldipd1	clc
	lda	PC
	adc	#8
	sta	PC
	bcc	ldipd2
	inc	PC+1
ldipd2	rts
*
.ldisd	lda	PC
	sta	VAL
	lda	PC+1
	sta	VAL+1
	jsr	.ldsec#
	jmp	ldipd1
*
.ldlpd	jsr	twolcl
	jmp	.ldacc#
*
.ldlsd	jsr	twolcl
	jmp	.ldsec#
*
.stld	jsr	twolcl
	jmp	.sdacc#
*
.pshld	jsr	twolcl
	jsr	.ldacc#
	jmp	.pshd#
*
.ldgpd	jsr	twoval
	jmp	.ldacc#
*
.ldgsd	jsr	twoval
	jmp	.ldsec#
*
.stgd	jsr	twoval
	jmp	.sdacc#
*
.pshgd	jsr	twoval
	jsr	.ldacc#
	jmp	.pshd#
*
.ldsd	lda	R0
	sta	VAL
	lda	R0+1
	sta	VAL+1
	jmp	.ldacc#
*
.stsd	jsr	pul0#
	lda	R1
	sta	VAL
	lda	R1+1
	sta	VAL+1
	jmp	.sdacc#
*
.inrd	jsr	.swapd#
	lda	#1
	sta	R0
	sty	R0+1
	jsr	.itod#
	jmp	.addd#
*
.dcrd	jsr	.swapd#
	lda	#-1
	sta	R0
	ldy	R0+1
	jsr	.itod#
	jmp	.addd#
*
twoval	lda	(PC),Y		;fetch two byte operand into VAL
	sta	VAL
	iny
	lda	(PC),Y
	sta	VAL+1
	dey
	clc
	lda	PC
	adc	#2
	sta	PC
	bcc	twoval1
	inc	PC+1
	clc
twoval1	rts
*
twolcl	clc			;fetch two byte local address into VAL
	lda	(PC),Y
	adc	FRAME
	sta	VAL
	iny
	lda	(PC),Y
	adc	FRAME+1
	sta	VAL+1
	dey
	clc
	lda	PC
	adc	#2
	sta	PC
	bcc	twolcl1
	inc	PC+1
	clc
twolcl1	rts
*
flt1.a65
*:ts=8
* Copyright (c) 1982,1985 by Manx Software Systems
*
*
	instxt	<zpage.h>


PREC	EQU	8

	global	Sysvec_,8
	global	flterr_,2

	dseg
*
acc3	rmb	PREC+2
SIZ	rmb	1
TMP0	rmb	1
TMP1	rmb	1
TMP2	rmb	1
*
	cseg
	public	.flt1
.flt1
*
	public	.lsacc
	public	.ldacc
	public	.lssec
	public	.ldsec
	public	.ssacc
	public	.sdacc
	public	.addd
	public	.subd
	public	.muld
	public	.divd
	public	.eqd
	public	.ned
	public	.ltd
	public	.led
	public	.gtd
	public	.ged
	public	.swapd
	public	.tstd
	public	.dtoi
	public	.dtou
	public	.dtox
	public	.itod
	public	.utod
	public	.xtod
	public	.rndit
	public	.stflt
*
	cseg
*
*
*
*	load packed float pointed at by VAL into sec
*
.lssec	lda	#5
	bne	ldsec1
.ldsec	lda	#9
ldsec1	sta	SIZ
	jsr	.swapd
	jsr	ldflt
	jmp	.swapd
*
*	load packed float pointed at by VAL into acc
*
.lsacc	lda	#5
	bne	ldacc1
	public	.ldacc
.ldacc	lda	#9
ldacc1	sta	SIZ
*
*	called with VAL pointing at packed float
*
ldflt	ldy	#0
	lda	(VAL),Y
	sta	(ACC),Y
	iny
	and	#$7F
	sec
	sbc	#64
	sta	(ACC),Y
	lda	VAL
	bne	ldflt1
	dec	VAL+1
ldflt1	dec	VAL
	iny
ldflt2	lda	(VAL),Y
	sta	(ACC),Y
	iny
	cpy	SIZ
	bne	ldflt2
	lda	#0
ldflt3	sta	(ACC),Y
	iny
	cpy	#PREC+2
	bne	ldflt3
	tay
	rts
*
*	store acc into location in VAL
*
.ssacc	ldy	#5
	bne	.stflt
.sdacc	ldy	#9
*
*	store float pointed at by ACC into location in VAL
*
.stflt	sty	SIZ
	jsr	.rndit
	lda	VAL
	bne	stflt1
	dec	VAL+1
stflt1	dec	VAL
	ldy	SIZ
	dey
stflt2	lda	(ACC),Y
	sta	(VAL),Y
	dey
	cpy	#1
	bne	stflt2
	clc
	lda	(ACC),Y
	adc	#64
	sta	SIZ
	dey
	lda	(ACC),Y
	and	#$80
	ora	SIZ
	iny
	sta	(VAL),Y
	rts
*
*	round the result in the ACC
*
	public	.rndit
.rndit	lda	(ACC),Y
	bmi	rndit2
rndit1	rts
rndit2	sty	TMP1
	lda	#0
	sta	(ACC),Y
	dey
	tya
	tax
	dex
	sec
rndit3	lda	(ACC),Y
	adc	#0
	sta	(ACC),Y
	dey
	dex
	bne	rndit3
	bcc	rndit1
rndit4	ldy	#2
	ldx	#1
rndit5	lda	(ACC),Y
	sta	TMP2
	txa
	sta	(ACC),Y
	ldx	TMP2
	iny
	cpy	TMP1
	bne	rndit5
	ldx	#0
	ldy	#1
	clc
	tya
	adc	(ACC),Y
	sta	(ACC),Y
	cmp	#65
	bne	rndit1
	jmp	ovrflow
*
*	subtract secondary from primary
*
.subd	ldy	#0
	lda	(SEC),Y
	eor	#$80
	sta	(SEC),Y
*
*	add secondary to primary
*
	public	.addd
.addd	ldy	#1
	lda	(ACC),Y
	cmp	(SEC),Y
	beq	add3
	bmi	add1
	jsr	.swapd
add1	ldy	#2
	ldx	#0
add1a	lda	(ACC),Y
	sta	SIZ
	txa
	sta	(ACC),Y
	ldx	SIZ
	iny
	cpy	#PREC+2
	bne	add1a
	ldx	#0
	jsr	tstman
	bne	add2
	jmp	.swapd
add2	clc
	ldy	#1
	tya
	adc	(ACC),Y
	sta	(ACC),Y
	jmp	.addd
add3	dey
	lda	(ACC),Y
	eor	(SEC),Y
	bmi	add7
	clc
	ldx	#PREC
	ldy	#PREC+1
add4	lda	(ACC),Y
	adc	(SEC),Y
	sta	(ACC),Y
	dey
	dex
	bne	add4
	bcs	add6
add5	rts
add6	ldy	#PREC+2
	sty	TMP1
	jmp	rndit4
add7	lda	(ACC),Y
	bpl	add7a
	jsr	.swapd
add7a	sec
	ldx	#PREC
	ldy	#PREC+1
add8	lda	(ACC),Y
	sbc	(SEC),Y
	sta	(ACC),Y
	dey
	dex
	bne	add8
	bcs	add10
	ldy	#0
	lda	#$80
	sta	(ACC),Y
	ldy	#PREC+1
	ldx	#PREC
	sec
add9	lda	#0
	sbc	(ACC),Y
	sta	(ACC),Y
	dey
	dex
	bne	add9
add10	jsr	tstman
	bne	add11
	lda	#$0
	tay
	sta	(ACC),Y
	iny
	lda	#-64
	sta	(ACC),Y
	rts
add11	jmp	normal
*
*	normalize the number in the acc
*
normal	ldy	#2
	lda	(ACC),Y
	beq	norm1
	rts
norm1	ldy	#PREC+1
	ldx	#0
norm2	lda	(ACC),Y
	sta	SIZ
	txa
	sta	(ACC),Y
	ldx	SIZ
	dey
	cpy	#1
	bne	norm2
	ldx	#0
	lda	(ACC),Y
	cmp	#-64
	bne	norm3
	jmp	undflow
norm3	sec
	sbc	#1
	sta	(ACC),Y
	jmp	normal
*
*	test mantissa of acc
*
tstman	ldy	#2
tstman1	lda	(ACC),Y
	bne	tstman2
	iny
	cpy	#PREC+2
	bne	tstman1
tstman2	tay
	rts
*
*	multiply acc by sec, result in acc
*
	public	.muld
.muld	ldy	#1
	lda	(ACC),Y
	cmp	#-64
	beq	mul1
	lda	(SEC),Y
	cmp	#-64
	bne	mul2
mul1	jmp	dozero
mul2	dey
	lda	(ACC),Y
	eor	(SEC),Y
	sta	(ACC),Y
	iny
	clc
	lda	(ACC),Y
	adc	(SEC),Y
	sta	(ACC),Y
	bmi	mul3
	cmp	#65
	bcc	mul4
	jmp	ovrflow
mul3	cmp	#-64
	bcs	mul4
	jmp	undflow
mul4	ldy	#2
	ldx	#0
mul5	lda	(ACC),Y
	sta	acc3,Y
	txa
	sta	(ACC),Y
	iny
	cpy	#PREC+2
	bne	mul5
	ldy	#PREC
	sty	SIZ
mul6	ldy	SIZ
	lda	acc3+1,Y
	bne	mul8
	ldy	#2
	ldx	#0
mul7	lda	(ACC),Y
	sta	TMP0
	txa
	sta	(ACC),Y
	ldx	TMP0
	iny
	cpy	#PREC+2
	bne	mul7
	ldx	#0
	beq	mul14
mul8	sta	TMP0
	sec
	bcs	mul10
mul9	clc
mul10	ror	TMP0
	bcc	mul12
	clc
	ldy	#PREC+1
	ldx	#PREC
mul11	lda	(ACC),Y
	adc	(SEC),Y
	sta	(ACC),Y
	dey
	dex
	bne	mul11
mul12	ldy	#2
	ldx	#PREC
mul13	lda	(ACC),Y
	ror	A
	sta	(ACC),Y
	iny
	dex
	bne	mul13
	lda	TMP0
	lsr	A
	bne	mul9
mul14	dec	SIZ
	bne	mul6
	jsr	tstman
	bne	mul15
	jmp	dozero
mul15	jmp	normal
*
*	divide the two doubles
*
.divd	lda	SEC
	sta	VAL
	lda	SEC+1
	sta	VAL+1
	jsr	tstd1
	bne	ddiv1
	jmp	div0
ddiv1	jsr	.tstd
	bne	ddiv2
	jmp	dozero
ddiv2	ldy	#0
	lda	(ACC),Y
	eor	(SEC),Y
	sta	(ACC),Y
	iny
	sec
	lda	(ACC),Y
	sbc	(SEC),Y
	sta	(ACC),Y
	bmi	ddiv3
	cmp	#65
	bcc	ddiv4
	jmp	ovrflow
ddiv3	cmp	#-64
	bcs	ddiv4
	jmp	undflow
ddiv4	ldy	#2
ddiv5	lda	(ACC),Y
	cmp	(SEC),Y
	bcc	ddiv7		;u < v
	bne	ddiv6		;u > v
	iny
	cpy	#PREC+2
	bne	ddiv5
ddiv6	ldy	#1		;u >= v
	clc
	lda	(ACC),Y
	adc	#1
	sta	(ACC),Y
	ldx	#2
	lda	#0
	sta	acc3,X
	inx
	bne	ddiv8
ddiv7	ldx	#2		;u < v
ddiv8	ldy	#2
ddiv9	lda	(ACC),Y
	sta	acc3,X
	lda	#0
	sta	(ACC),Y
	iny
	inx
	cpx	#PREC+2
	bne	ddiv9
	ldy	#PREC+1
	sta	(ACC),Y
	ldx	#PREC*8
	stx	SIZ
ddiv10	ldy	#PREC+1
	ldx	#PREC
	clc
ddiv11	lda	(ACC),Y
	rol	A
	sta	(ACC),Y
	dey
	dex
	bne	ddiv11
	ldy	#PREC-1
ddiv12	lda	acc3+2,Y
	rol	A
	sta	acc3+2,Y
	dey
	bpl	ddiv12
	bcs	ddivj
	ldy	#2
ddiv13	lda	acc3,Y
	cmp	(SEC),Y
	bcc	ddiv16
	bne	ddiv14
	iny
	cpy	#PREC+2
	bne	ddiv13
ddivj	sec
ddiv14	ldy	#PREC+1
	ldx	#PREC
ddiv15	lda	acc3,Y
	sbc	(SEC),Y
	sta	acc3,Y
	dey
	dex
	bne	ddiv15
	ldy	#PREC+1
	clc
	lda	(ACC),Y
	adc	#1
	sta	(ACC),Y
ddiv16	dec	SIZ
	bne	ddiv10
	jmp	normal
*
*	swap the two accumulators
*
	public	.swapd
.swapd	lda	ACC
	ldx	SEC
	sta	SEC
	stx	ACC
	lda	ACC+1
	ldx	SEC+1
	sta	SEC+1
	stx	ACC+1
	ldx	#0
	rts
*
.eqd	jsr	dcmp
	beq	true
false	lda	#0
	sta	R0
	sta	R0+1
	rts
*
.ned	jsr	dcmp
	beq	false
true	ldx	#1
	stx	R0
	dex
	stx	R0+1
	rts
*
.ltd	jsr	dcmp
	bmi	true
	bpl	false
*
.led	jsr	dcmp
	bmi	true
	beq	true
	bne	false
*
.gtd	jsr	dcmp
	bmi	false
	beq	false
	bne	true
*
.ged	jsr	dcmp
	bmi	false
	bpl	true
*
dcmp	ldy	#0
	lda	(ACC),Y
	bmi	dcmp1
	eor	(SEC),Y
	bmi	a.gt.s
	bpl	dcmp2
dcmp1	eor	(SEC),Y
	bmi	a.lt.s
	jsr	.swapd
dcmp2	iny
	lda	(ACC),Y
	cmp	(SEC),Y
	bmi	a.lt.s
	bne	a.gt.s
dcmp3	iny
	lda	(ACC),Y
	cmp	(SEC),Y
	bcc	a.lt.s
	bne	a.gt.s
	cpy	#PREC+1
	bne	dcmp3
	lda	#0
	rts
*
a.gt.s	lda	#1
	rts
*
a.lt.s	lda	#-1
	rts
*
.utod
	ldy	#0
	lda	R0
	ora	R0+1
	beq	dozero
	tya
	ldx	#2
	bne	tod
*
.itod
	ldy	#0
	lda	R0
	ora	R0+1
	beq	dozero
	ldx	#2
	lda	R0+1
	bpl	tod
	sec
	tya
	sbc	R0
	sta	R0
	tya
	sbc	R0+1
	sta	R0+1
	lda	#$80
tod	sta	(ACC),Y
	iny
	txa
	sta	(ACC),Y
	iny
tod1	lda	R0-1,X
	sta	(ACC),Y
	iny
	dex
	bne	tod1
	lda	#0
tod2	sta	(ACC),Y
	iny
	cpy	#PREC+2
	bne	tod2
	jmp	normal
*
dozero	ldy	#PREC+1
	lda	#0
dozero1	sta	(ACC),Y
	dey
	bpl	dozero1
	ldy	#1
	lda	#-64
	sta	(ACC),Y
	rts
*
.xtod
	ldy	#0
	ldx	#-4
	tya
xtod1	ora	R0+4,X
	inx
	bne	xtod1
	tax
	beq	dozero
	ldx	#4
	lda	R0+3
	bpl	tod
	sec
	ldx	#-4
xtod2	tya
	sbc	R0+4,X
	sta	R0+4,X
	inx
	bne	xtod2
	ldx	#4
	lda	#$80
	bne	tod
*
.dtox	ldy	#0
	ldx	#5
	bne	dtoi1
*
.dtou	ldy	#1
	bne	dtoi0
*
.dtoi	ldy	#0
dtoi0	ldx	#3
dtoi1	stx	SIZ
	ldx	#0
	sty	TMP0
	ldy	#1
	lda	(ACC),Y		;how big is it?
	beq	dtoi2
	bpl	dtoi3
dtoi2	lda	#0		;<= 0 is too small to convert
	beq	fin1
dtoi3	cmp	SIZ		;too big?
	bcc	dtoi6		;no
	lda	TMP0		;yes, are we signed
	beq	dtoi4		
	lda	#-1		;unsigned, do biggest possible
	sta	R0
	sta	R0+1
	rts
dtoi4	dey
	ldx	SIZ
	lda	#$7F		;no, do biggest positive
	sta	R0-2,X
	lda	#$FF
	bne	fin
dtoi6	tax
	pha
	iny
dtoi7	lda	(ACC),Y
	sta	R0-1,X
	iny
	dex
	bne	dtoi7
	pla
	tax
	inx
	lda	#0
	beq	fin2
*
fin	dec	SIZ
fin1	ldx	#1
fin2	cpx	SIZ
	bne	fin5
	ldy	#0
	lda	(ACC),Y
	bpl	fin4
	sec
	ldx	#0
	ldy	#4
fin3	lda	#0
	sbc	R0,X
	sta	R0,X
	inx
	dey
	bne	fin3
fin4	ldx	#0
	rts
fin5	sta	R0-1,X
	inx
	bne	fin2
*
.tstd	lda	ACC
	sta	VAL
	lda	ACC+1
	sta	VAL+1
tstd1	ldy	#0
	lda	(VAL),Y
	bne	tstd2
	iny
	lda	(VAL),Y
	cmp	#-64
	bne	tstd2
	iny
	lda	(VAL),Y
	bne	tstd2
	lda	#0
	sta	R0
	sta	R0+1
	rts
tstd2	ldy	#0
	sty	R0+1
	iny
	sty	R0
	rts
*
ovrflow	lda	#2
	jsr	usrrtn
dobig	ldy	#1
	lda	#63
	sta	(ACC),Y
	iny
	lda	#$FF
over1	sta	(ACC),Y
	iny
	cpy	#9
	bne	over1
	lda	#0
	sta	(ACC),Y
	rts
*
undflow	lda	#1
	jsr	usrrtn
	ldy	#PREC+1
	lda	#0
undflo1	sta	(ACC),Y
	dey
	bpl	undflo1
	ldy	#1
	lda	#-63
	sta	(ACC),Y
	tya
	iny
	sta	(ACC),Y
	rts
*
div0	lda	#3
	jsr	usrrtn
	jmp	dobig
*
usrrtn	sta	flterr_
	lda	Sysvec_
	ora	Sysvec_+1
	beq	mine
	sec
	lda	SP
	sbc	#4
	sta	SP
	bcs	usrrtn1
	dec	SP+1
usrrtn1	ldy	#3
	lda	PC+1
	sta	(SP),Y
	dey
	lda	PC
	sta	(SP),Y
	dey
	lda	#0
	sta	(SP),Y
	dey
	lda	flterr_
	sta	(SP),Y
	lda	Sysvec_
	sta	VAL
	lda	Sysvec_+1
	sta	VAL+1
	jsr	dojmp
	clc
	lda	SP
	adc	#4
	sta	SP
	bcc	usrrtn2
	inc	SP+1
usrrtn2	rts
*
dojmp	jmp	(VAL)
*
mine	sec
	lda	SP
	sbc	#56
	sta	SP
	bcs	mine1
	dec	SP+1
mine1	ldy	#6
mine2	lda	msg1-6,Y
	beq	mine3
	sta	(SP),Y
	iny
	bne	mine2
mine3	lda	flterr_
	tax
	dex
	lda	mtab,X
	tax
mine4	lda	msg,X
	beq	mine5
	sta	(SP),Y
	iny
	inx
	bne	mine4
mine5	ldx	#0
mine6	lda	msg2,X
	beq	mine7
	sta	(SP),Y
	iny
	inx
	bne	mine6
mine7	ldx	#0
	lda	PC+1
	jsr	dohex
	lda	PC
	jsr	dohex
	lda	#10
	sta	(SP),Y
	tya
	sec
	sbc	#5
	ldy	#4
	sta	(SP),Y
	iny
	lda	#0
	sta	(SP),Y
	ldy	#1
	sta	(SP),Y
	dey
	lda	#2
	sta	(SP),Y
	tay
	clc
	lda	SP
	adc	#6
	sta	(SP),Y
	iny
	lda	SP+1
	adc	#0
	sta	(SP),Y
	jsr	write_#
	clc
	lda	SP
	adc	#56
	sta	SP
	bcc	mine8
	inc	SP+1
mine8	ldx	#0
	rts
*
dohex	sta	SIZ
	lsr	A
	lsr	A
	lsr	A
	lsr	A
	jsr	phex
	lda	SIZ
	and	#$0F
phex	tax
	lda	chars,X
	ldx	#0
	sta	(SP),Y
	iny
	rts
*
chars	fcc	/0123456789ABCDEF/
msg1	fcc	/Floating pt /
	fcb	0
msg2	fcc	/ at loc 0x/
	fcb	0
mtab	fcb	mund-msg,mover-msg,mdiv0-msg
msg
mund	fcc	/underflow/
	fcb	0
mover	fcc	/overflow/
	fcb	0
mdiv0	fcc	/divide by 0/
	fcb	0
*
*
*
	cseg
